#!/system/bin/sh

# 定义模块路径
MODULE_PATH="/data/adb/modules/鸡鸡的温度"

# 定义配置目录路径
CONFIG_PATH="/storage/emulated/0/Android/hons"

# 获取当前 CPU 温度值
CURRENT_CPU_TEMP=$(grep '^cpu温度=' "$CONFIG_PATH/鸡鸡温控.rc" | cut -d'=' -f2)

# 反转 CPU 温度值
NEW_CPU_TEMP=$((50000 - $CURRENT_CPU_TEMP))

# 更新配置文件
sed -i "s/^cpu温度=.*/cpu温度=$NEW_CPU_TEMP/" "$CONFIG_PATH/鸡鸡温控.rc"

# 获取当前 GPU 温度值
CURRENT_GPU_TEMP=$(grep '^gpu温度=' "$CONFIG_PATH/鸡鸡温控.rc" | cut -d'=' -f2)

# 反转 GPU 温度值
NEW_GPU_TEMP=$((50000 - $CURRENT_GPU_TEMP))

# 更新配置文件
sed -i "s/^gpu温度=.*/gpu温度=$NEW_GPU_TEMP/" "$CONFIG_PATH/鸡鸡温控.rc"

# 获取当前电池温度值
CURRENT_BATTERY_TEMP=$(grep '^电池温度=' "$CONFIG_PATH/鸡鸡温控.rc" | cut -d'=' -f2)

# 反转电池温度值
NEW_BATTERY_TEMP=$((30000 - $CURRENT_BATTERY_TEMP))

# 更新配置文件
sed -i "s/^电池温度=.*/电池温度=$NEW_BATTERY_TEMP/" "$CONFIG_PATH/鸡鸡温控.rc"

# 根据新的温度值执行相应操作
if [ "$NEW_CPU_TEMP" -eq 0 ] && [ "$NEW_GPU_TEMP" -eq 0 ] && [ "$NEW_BATTERY_TEMP" -eq 0 ]; then
    # 关闭温度伪装
    pkill -f "温度伪装"
    echo "温度伪装已关闭。"
else
    # 开启温度伪装
    "$MODULE_PATH/system/vendor/bin/温度伪装" &
    echo "温度伪装已开启。"
fi