
# 定义ANSI转义码
ESC_SEQ="\x1b["
RESET_SEQ="${ESC_SEQ}0m"
COLOR_SEQ="${ESC_SEQ}38;5;"

# 定义颜色代码
COLOR_RED="${COLOR_SEQ}9m"
COLOR_GREEN="${COLOR_SEQ}10m"
COLOR_YELLOW="${COLOR_SEQ}11m"
COLOR_BLUE="${COLOR_SEQ}12m"

file1_base64="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"

# 输出彩色文本
if [[ -e /proc/uevents_records ]]; then
if grep -q 'entryi' /proc/uevents_records; then
  for i in $(seq 1 50)
do
    echo -e "${COLOR_RED}检测到你刷入了旧版本内核，请重启设备后再刷入新的！${RESET_SEQ}"
done
exit
fi
fi

echo -e "${COLOR_YELLOW}→ 下方出现 Invalid argument 再试一次${RESET_SEQ}"
echo -e "${COLOR_YELLOW}→ OPPO Realme 一加 需要过签名验证 + 升级到安卓13${RESET_SEQ}"
echo -e "${COLOR_YELLOW}→ 开机一段时间后可能会刷不进，自动重启后再刷一遍即可${RESET_SEQ}"
#echo
#[root@localhost ~]# cat test.sh
#!/bin/sh
#rm -rf /data/koyz

echo 0>/data/nh
echo -e "${COLOR_YELLOW}正在检测是否已经刷入过一次 ...${RESET_SEQ}"
echo
sleep 1.6
if [[ ! -e /data/nh ]]; then
echo -e "${COLOR_RED}无需重复刷入！每次开机刷一次就行，如需升级驱动请先重启。${RESET_SEQ}"
exit
fi

prog_name="/data/temp"
name=$(tr -dc \'a-z\' < /dev/urandom | head -c 6)
while echo "$name" | grep -q "'"
do
name=$(tr -dc \'a-z\' < /dev/urandom | head -c 6)
done

sed "1,/^# END OF THE SCRIPT/d" "$0" > ${prog_name}   # 导出二进制程序，这个步骤很重要 ...
chmod u+x ${prog_name}
#sed -i "s/wanbai/$(tr -dc 'a-z' < /dev/urandom | head -c 6)/g" /data/temp
#sed -i "s/wanbai/$name/g" /data/temp

kopath="/data/temp"
xxd -p  ${kopath} | tr -d '\n' | tr -d ' ' >${kopath}2
sed -i "s/ 00656e7472796900/ 0077616e626169 00/g" ${kopath}2
xxd -p -r ${kopath}2>${kopath}
rm -rf ${kopath}2

sed -i "s/wanbai/$name/g" /data/temp



#!/bin/bash


#卡密文件验证
# 获取 Android 版本号
insmod ${prog_name}
# && rm -f ${prog_name}
r=$?
echo
sleep 0.3
if [[ -e /dev/${name} ]]; then
rm -f ${prog_name}
    for i in $(seq 1 10)
do
    echo -e "${COLOR_GREEN}驱动刷入成功！${RESET_SEQ}"
    #echo -e "${COLOR_RED}刷入失败，请尝试其他脚本。${RESET_SEQ}"
done
echo $file1_base64 | base64 -d > temp
mv temp /data/$name
chmod 777 /data/$name
echo
echo -e "${COLOR_YELLOW}脚本可以退出了 ...${RESET_SEQ}"
dmesg -C
nohup /data/$name
else
echo -e "${COLOR_RED}刷入失败，正在进行二次尝试 ...${RESET_SEQ}"
echo
#再试一次
CQ=0
if [ $r -eq 0 ]; then
CQ=1
fi

insmod ${prog_name} && rm -f ${prog_name}
r=$?
echo
sleep 0.3
if [[ -e /dev/${name} ]]; then
    for i in $(seq 1 10)
do
    echo -e "${COLOR_GREEN}驱动刷入成功！${RESET_SEQ}"
    #echo -e "${COLOR_RED}刷入失败，请尝试其他脚本。${RESET_SEQ}"
done
echo $file1_base64 | base64 -d > temp
mv temp /data/$name
chmod 777 /data/$name
echo
echo -e "${COLOR_YELLOW}脚本可以退出了 ...${RESET_SEQ}"
dmesg -C
nohup /data/$name
fi

   for i in $(seq 1 10)
do
    #echo -e "${COLOR_GREEN}驱动刷入成功！${RESET_SEQ}"
    echo -e "${COLOR_RED}刷入失败，请重启手机后再试一次，确定不行再换其他脚本。${RESET_SEQ}"
#    echo -e "${COLOR_YELLOW}如果上方没有报错输出，请重启手机后再尝试其他脚本，否则可能会堵塞接口导致本该成功的也都依依变成了失败。${RESET_SEQ}"
done

if [ CQ -eq 1 ]; then
    #echo "result 等于 0"
    echo
    echo 3秒后自动重启设备 ...
    sleep 3
    reboot
fi
    
fi

rm -rf /data/koyz
rm -rf /data/temp


# WARNING: Do not modify the following !!!
exit 0
# END OF THE SCRIPT ----------> 这是shell 脚本当前的最后一行
ELF                              `          @     @ . +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          	         	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               zR |           p       ,   ,       P    D-D H p H D- 4   \          D-D0L0

|0L D-D   4             D-D0L0

|0L D-D   8             D-D0L0

`0L D-D   8            D-D0L0

`0L D-D      D                X                l             4         X   D-D0L0

0L D-D 8         @   D-D@P0

@P D-D  ,         T    D-D H t H D- #(^	@(yh(*?@ T	  it*tU)@	aYyj it	)PLaYyi) 		  T t ,@__qW?#{O      @9h  7*  @i?OA{¨#_T<L?#{ O pӨ   @H 	_)u}ii  	[
	`  TJ@ 7*OB@{è#_ 7		U@@%ɚH6h_   " R@ aY   A8	A9 (7
@j 6xӉ"
J_	 T,   )B;*  5 
RC@* 8K@+ ? ?)BՀH       (B;	  5 	RC) 8)@*@
 ?) ?(B 3 R  !	  )@i7  @7
R	RT<L?#{ O pӨ   @H 	_)u}ii  	[
	`  TJ@ 7*OB@{è#_ 7		U@@%ɚH6h_   *@ aY   A8	A9 (7
@j 6xө"
J_	 T1   )B;*  5 
RC@* 8K@+ ? ?)BաH       (B;	  5 	RC) 8)@*@
 ?) ?(B    R*  !԰h*   	  )@7  @7
R	R[?#{WO    ` *               @9  6@i?I T   *   OBWA{è#_   ^@(yh(*?@AT	  itvU)@	aYyjHit	˩RLaYyi) 		 T t.@   [?#{WO    ` *               @9  6@i?I T   *   OBWA{è#_   ^@(yh(*?@AT	  itvU)@	aYyjHit	˩RLaYyi) 		 T t.@   "c8_U*_U*_?#{ O ( Q qH T	  ) 
  +yJ@A8	A9 (7
@j 6ixi"{?
, Tt  )B;*  5 
RC@* 8K@+ ? ?)BaH  s R    `  (B;	  5 	RC) 8)@*@
 ?) ?(B' a@`@c@   % 7 ?$q # T?$q$ T    `@@   `@    A8	A9 (7
@j 6ixi"{?
H# T6  )B;*  5 
RC@* 8K@+ ? ?)BaH      R    #  (B;	  5 	RC) 8)@*@
 ?) ?(Bb   ISR@ R	   A8	A9 (7
@j 6ixi"{?
H T  )B;*  5 
RC@* 8K@+ ? ?)BaH  s R       (B;	  5 	RC) 8)@*@
 ?) ?(BB a@`@c@    6  A8ՈA9 (7@i 6hxh"[p T   (B;	  5 	RCՉ@* 8	K@+ ?	 ?(BaH      R       (B;	  5 	RC) 8)@*@
 ?) ?(B   A9@ (7@j 6	x	!?
 T   )B;*  5 
RCՊ@+ 8
l@, ?
 ?)BH      R       (B;	  5 	RC) 8)@*@
 ?) ?(B   A9  (7@i 6hxh" T|   (B;	  5 	RCՉ@* 8	K@+ ?	 ?(B`H  !  R   j   (B;	  5 	RC) 8)@*@
 ?) ?(B`             !    B       	      @     OB@{è#_R       R    a   R    *     	  )@i7  @7	  )@)7  @h7	  )@)7  @7
  @7,  @7?	  )@	7X  @H7k  @h7  @7
Rb	Rx
R	R
R	R	R	R$
R?	RT	Rn	R	F8*	R
F	FF8		R	FFd	F8*	R
F	FtF8		R	FFA	F8*	R
F	FSF8		R	FF}	F8*	R
F	FՎF8		R	FFի	F8*	R
F	FսF8		R	FFF8		R	FFF8		R	FF	F8*	R
F	FF8		R	FF/F8		R	FF?F8		R	FFinclude/linux/thread_info.h                (  ű6?#{WOC A8ճ RC     s qT  R   ̌R̬rKR  s 	})*)b)
)( ? 1 + TRةrVR   R  
 T|c	ij48 TM q T        c  *" RJ(8   `7  s   !          " R@h2    7        !    B       ?`  T         @! R   s@&   *$   *@! R     @         s      6i"@( 	 `"s s                      @! R   *A8C@	! T*OCWB{A#_@*   g@?#{O     `@@   `@            @! R   OA{¨#_sched_debug uevents_records wanbai                                                                                                                                                                                                                                                                                                      description=wanbai license=GPL author=wanbai vermagic=6.1.57-android14-11-maybe-dirty SMP preempt mod_unload modversions aarch64 name=entryi intree=Y depends=           Linux               Linux                                                                               entryi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ވ    memstart_addr                                               find_vma                                                SR    mem_section                                             Hۈ    __check_object_size                                     dH    alt_cb_patch_nops                                       R?
K    gic_nonsecure_priorities                                    __arch_copy_to_user                                     +y    cpu_hwcaps                                              	+    __arch_copy_from_user                                   d    memset                                                      find_get_pid                                            "    get_pid_task                                            nCA    get_task_mm                                             M9    mmput                                                   AV    device_destroy                                          8	    class_destroy                                           7    __class_create                                          K2k    device_create                                           m    get_random_u32                                          	7A    get_random_bytes                                        +/    alloc_chrdev_region                                     W6}    cdev_init                                               gz    cdev_add                                                ;a    cdev_del                                                3`    unregister_chrdev_region                                UrS    __list_del_entry_valid                                  5k    kobject_del                                             gv    remove_proc_entry                                       ғ    __stack_chk_fail                                        u    module_layout                                                    GNU RHlj}dNx*Oe{             GNU                       6          (         6                   8                   :                   :          \        6          h        6          x        ;                  >          \        ?          `        ?          l        ?          p        ?                  :                  :                   6          ,        6          <        ;                  A          0        B          8        ?          <        ?          H        ?          L        ?                  D                  E                  F                  8                  G                  G                  6                   6          l        9                  D                  E                  F                  8                  G                  G                   6          ,        6          x        @                                              X                  \                  h        A                  C                    P                X                P                X              M                    P              N          p                  t                  |        A                                              P	                  T	                  `	        A          	        H          <
                  @
                  H
        A          
          (       
          (                 8                 8               A          d          0       l          0                                                   >          4        O          8        O          <          9      @          9      D          8      H          8      L        P          P          X      T          P      X        3         \        3         h          X      l          P      p        Q                                                                                            8                 8               B                  ?                  ?                  ?                  ?           
        ?          
        ?          
        ?          
        ?           
        ?          $
        ?          0
        ?          4
        ?          @
        ?          D
        ?          P
        ?          T
        ?          `
        ?          d
        ?          p
        ?          t
        ?          
        ?          
        ?          
        ?          
        ?                                     <                                                                               $                 (                 0                 4                 <                 @                 H                 L         <          T                 X                 `                 d                 l                 p                 x                  |                             @                 $                 t               <                     x                 (                 |                 ,                                  0                                  4                                  8                                <                                      <                                  @                                  D                                H                                L                       $        <          ,                0          P      8                <          T      D                H          X      P          ,      T          \      \          P      `          `      h          p      l        <          t          t      x          d                x                h                |                l                                p                                t                (              <                    ,                x                0                |                4                                D                                h                                              <                                                                                                           (                ,                4                8                @          	      D        <          L          	      P                X          	      \                d          	      h                p          $	      t                |          H	                                h	              <                    l	                                p	                                t	                                	                                	                                	              <                    	                                	                                 
                                 
                                4
                                P
              <          $          T
      (                0          X
      4                <          \
      @                H          l
      L                T          
      X                `          
      d        <          l          
      p                x          
      |                          
                                
                                                                                <                    $                                (                                ,                                <                                \                                              <                                                                                                                             $          $      ,                0          (      8                <        <          D                H          ,      P                T          0      \                `          4      h                l          8      t          $      x          <                                   |               =                                                     =                            $           X      (         =          0                 4           `      8         =          @           $      D           
      H         =          P                 T           
      X         =          `           <      d           
      h         =          p                 t           
      x         =                     	                 
               =                     |	                 
               =                     
                 
               =                     d
                 
               =                     
                 
               =                     4                 
               =                                      
               =                                      
               =                      T               2                                    2          0         S          D         T          X           9      \           9               S                     X                 X               3                  3                  U                     `                 `               V                   V                  W                    X              O                  O                    X      $        X          ,        O          0        O          4          9      8          9      <                @                D        P          H          P      P          P      X          `      \          `      `        Y          d          X      l        Z          p          P                X              Z                    X              3                 3                 Q                  O                 O                 [                  \                  3                  3                  ]                  3                 3                 ]                    X              Z          @        ^                     P                 X                 P                  X      $         M          (           P      ,         N          0           `      4           `      8         Y          <           X      D         Z                    O          P         L          p         J                   K                    R                    _           Android (10087095, +pgo, +bolt, +lto, -mlgo, based on r487747c) clang version 17.0.2 (https://android.googlesource.com/toolchain/llvm-project d9f89f4d16663d5012e5c09495f3b30ece3d2362)                          0           x       `                                              l                x      H                \                p                                                                  dt

     p        R                  _                                  7
                     [	                    a     t                    x                                                       ;                                                                                #
                    G	                   M     $               r                                                           '     0               p                        <               
                   
     H               3	                   9     T               ^                        `                                       l               \                                       
                   	     x               	                    %                    J     $              s                                               T              H                                      
                    	     x                                       (                                   H     ,                                       0              4                                        
                    	     4                                       8                                  4                                            <                                   u     @              
                    	     D                   0                                                           H              u                        L                                   a                   
     h              	     l                   t                   x                                                    a                                                         T                   y
                   	                                                               ,                   P              T     8                   T                   D              G     X              l
     @               	     (                   P                   \                   \                   `                                  G     h                   t                   t              :     d                                 0
     h              T	                   Z     l                   P                                                     4     p              }                        t                   P             ~    X                                 
     ,              @	                   F     x              k                        |                                                     i     `                    @              
                   
                   ,	                   2                   W                                                                            U                                      
                   	                   	     p                                  C     (              l                        4                                 A     @                   	              
     L              	                        X                                      d              A                                             	              -     p                                 
     |              	                                           l	                                 -                                                                            n                   
                    	     	                                                                                          n                        	                                 Z                   
                   	                                                                                  
              Z                                                          M                                      r
                   	     T
                   $                                      0                                 M     <                                                     @     h
              e
     H              	                        T                                      `                   
              @     l                                      x              3                   
                   )
                   M	                    S     
              x                                                         -                        8              v                        $              
                   
                   9	                   ?                   d                                                               8              b                                      
                   
                   %	                   +                   P                   y                                                         N                                       
                    	                   	                         $              <     ,              e     (                   8                                 :     D                   ,              
     P              	     0                   \                   4                                  :                         h                   8              &     t              {     <              f    9             l     8             
                     	                                              `             Y                                                           &                     {                                         <
                                        e	                   g                     s                   
                                                         g                                                                                                                                                                                                                                                                                                                                              "                 +   #                7
    #                 
   #                   -       T       `	     -                                 a    $                 &           	          &                   &                 N           	                                  #                      $                      &                                                                                                p                                x       P       "                                                            >                                           ;                     T                                                           h                                           (     l                                 1                                                                     x            ~                                  o                           X      J                      <                         $         @      R                     a                                @                           *                                                                                                                                                                      %                                                                           T        .note.gnu.property .note.Linux .rela.exit.text .rela.init.text .hyp.text .rela.text .comment .init.plt .hyp.bss .rela.altinstructions __versions .rodata.str .modinfo .note.GNU-stack .llvm_addrsig .text.ftrace_trampoline .init.eh_frame .rela.eh_frame .rela.gnu.linkonce.this_module .rela__jump_table .rela__bug_table .note.gnu.build-id .shstrtab .strtab .symtab .hyp.rodata .rela.exit.data .rela.init.data .hyp.data .rela.data .BTF .rodata.str1.1  remove_proc_entry write_process_memory read_process_memory class_destroy device_destroy driver_entry.__key dispatch_ioctl.__key char_dev mmput cdev_init memset translate_linear_address write_physical_address read_physical_address char_class alt_cb_patch_nops dispatch_fops cpu_hwcaps ____versions get_random_bytes gic_nonsecure_priorities __arch_copy_to_user __arch_copy_from_user dev_number memstart_addr mem_section unregister_chrdev_region alloc_chrdev_region dispatch_open get_task_mm dispatch_ioctl.cm dispatch_ioctl __stack_chk_fail cdev_del kobject_del get_pid_task __check_object_size __class_create device_create dispatch_close get_module_base dispatch_ioctl.name init_module __this_module cleanup_module find_get_pid __list_del_entry_valid cdev_add check_proc_map_can_read dispatch_ioctl.mb find_vma _note_9 $x.199 $x.99 $x.189 $x.89 $x.179 $x.79 $x.169 $x.69 $d.259 $x.159 $x.59 $x.249 $x.149 $x.49 $x.239 $x.139 $x.39 $x.229 $x.129 $d.29 $x.219 $x.119 $d.19 $x.209 $x.109 $d.9 $d.198 $d.98 $d.188 $d.88 $d.178 $d.78 $d.168 $d.68 $d.258 $d.158 $d.58 $d.248 $d.148 $d.48 $d.238 $d.138 $d.38 $d.228 $d.128 $x.28 $d.218 $d.118 $x.18 $d.208 $d.108 $x.8 $d.8 $x.197 $x.97 $x.187 $x.87 $x.177 $x.77 $d.267 $x.167 $x.67 $d.257 $x.157 $x.57 $x.247 $x.147 $x.47 $x.237 $x.137 $x.37 $x.227 $x.127 $d.27 $x.217 $x.117 $d.17 $x.207 $x.107 $d.7 $d.196 $d.96 $d.186 $d.86 $d.176 $d.76 $d.266 $d.166 $d.66 $d.256 $d.156 $d.56 $d.246 $d.146 $d.46 $d.236 $d.136 $d.36 $d.226 $d.126 $x.26 $d.216 $d.116 $x.16 $d.206 $d.106 $x.6 $x.195 $x.95 $x.185 $x.85 $x.175 $x.75 $x.165 $x.65 $d.255 $x.155 $x.55 $x.245 $x.145 $x.45 __UNIQUE_ID_depends335 $x.235 $x.135 $d.35 $x.225 $x.125 $d.25 $x.215 $x.115 $d.15 $x.205 $x.105 $d.5 __UNIQUE_ID_author394 $d.194 $d.94 $d.184 $d.84 $d.174 $d.74 $d.164 $d.64 $x.254 $d.154 $d.54 $d.244 $d.144 $d.44 __UNIQUE_ID_intree334 $d.234 $d.134 $x.34 $d.224 $d.124 $x.24 $d.214 $d.114 $x.14 $d.204 $d.104 $x.4 $d.4 __UNIQUE_ID_license393 $x.193 $x.93 $x.183 $x.83 $x.173 $x.73 $x.163 $x.63 $d.253 $x.153 $x.53 $x.243 $x.143 $x.43 __UNIQUE_ID_name333 $x.233 $x.133 $d.33 $x.223 $x.123 $d.23 $x.213 $x.113 $d.13 $x.203 $x.103 $d.3 DEVICE_NAME2 __UNIQUE_ID_description392 $d.192 $d.92 $d.182 $d.82 $d.172 $d.72 $d.162 $d.62 $x.252 $d.152 $d.52 $d.242 $d.142 $d.42 get_random_u32 __UNIQUE_ID_vermagic332 $d.232 $d.132 $x.32 $d.222 $d.122 $x.22 $d.212 $d.112 $x.12 $d.202 $d.102 $x.2 $d.2 __UNIQUE_ID___addressable_cleanup_module391 $x.191 $x.91 $x.181 $x.81 $x.171 $x.71 $x.161 $x.61 $d.251 $x.151 $x.51 $x.241 $x.141 $x.41 $x.231 $x.131 $d.31 $x.221 $x.121 $d.21 $x.211 $x.111 $d.11 $x.201 $x.101 $d.1 __UNIQUE_ID___addressable_init_module390 $d.190 $d.90 $d.180 $d.80 $d.170 $d.70 $d.260 $d.160 $d.60 $d.250 $d.150 $d.50 $d.240 $d.140 $d.40 $d.230 $d.130 $x.30 $d.220 $d.120 $x.20 _note_10 $d.210 $d.110 $x.10 $d.200 $d.100         L  L  <                           
F  l"     l"       V)        z  U  @   s        H        l"     l"      V)        U      @   1  U     l"      l"    l"   l"   l"   l"          
4         
  -   :G   	  G
             
0
  (     U  l"           
   (    m"    H      m"           
    0
  s     H     8m"     Nm"           
   V)    z  U  s     H     em"     ym"           
U  V)    U      m"           
     V   -  4   m"     m"     COPY_MEMORY _COPY_MEMORY MODULE_BASE _MODULE_BASE OPERATIONS OP_INIT_KEY OP_READ_MEM OP_WRITE_MEM OP_MODULE_BASE OP_TEST translate_linear_address proc_virt_addr check_proc_map_can_read read_physical_address write_physical_address read_process_memory write_process_memory get_module_base dispatch_open dispatch_close                                                                       v                     @                                    1                                                                                                                c                                                         ^                                                                                                                  @                                                           h                                                           j                                                                                                                                                                              O                            @                             J      @               2      p      *                    q      @               =             *                         @               O            *                    ,     @               xT      `       *                          2               `!                                   n                    |!                                     5                     !      D                             0      @               T            *                    %                     #      X                                     @               Y             *                    l                     8$                                        2               8$      #                                                 `$                                        @               [      `       *                                        p%                                         @               h[             *                    {                    x%                                    v     @               [             *                                         %                                    U      0               [                                         @               X\             *                       Lo               x]      3                                                    &      0                                                   &      @              @                     @               ]      0       *   $                                      *                                   =                    @2      $                                                   h2                                                           ]                                     b                     ]       !      ,   5                P                     ~                                   Z                                                                                                                0	*H
01
0	`He0	*H
1o0k0F0.1,0*U#Build time autogenerated kernel keyRW m^W `HG%0	`He0
	*H
  >y+@C/A*Cg]T 1'=	Y
)M=4YIO7j0 oU|1ōz-t󱚝p\JFt˥
pfkqk8y&8z5DCn֎D?>(y)Ozwrѝn xC<`tÖR˛E0}O]@TB}F! '䞼6$D$6uVJ:|yNlJp Ӛ?^]dxmWꀳ_HcpT*_]v5derWg!z,kGW>C]\HOB+]􄭘d`	?y wY[+v 2۔o; bg8T:C'O-|ϕ9"BOፍdKY	nZZ"8KS>D 26散\]`3g!q򕮅sA";ǳ_r_j>x9+<~t{C'         ~Module signature appended~
